import { z } from 'zod';
import { APIClient } from '../api';
declare const MachineSchema: z.ZodObject<{
    id: z.ZodString;
    instanceId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    privateIPv4: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    availabilityZone: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    deploymentCount: z.ZodOptional<z.ZodNumber>;
    status: z.ZodString;
    provider: z.ZodString;
    region: z.ZodString;
    startedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    stoppedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    pausedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    erroredAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    error: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    orgId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    orgName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    updatedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
}, z.core.$strip>;
export type Machine = z.infer<typeof MachineSchema>;
export declare function machineList(client: APIClient): Promise<Machine[]>;
export declare function machineGet(client: APIClient, machineId: string): Promise<Machine>;
export declare function machineDelete(client: APIClient, machineId: string): Promise<boolean>;
declare const MachineDeploymentSchema: z.ZodObject<{
    id: z.ZodString;
    identifier: z.ZodOptional<z.ZodString>;
    state: z.ZodOptional<z.ZodString>;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        identifier: z.ZodString;
        domains: z.ZodArray<z.ZodString>;
    }, z.core.$strip>>>;
    resources: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        cpuUnits: z.ZodNumber;
        memoryUnits: z.ZodNumber;
        diskUnits: z.ZodNumber;
    }, z.core.$strip>>>;
    customDomains: z.ZodArray<z.ZodString>;
    paused: z.ZodBoolean;
    pausedDuration: z.ZodNumber;
    domainSuffix: z.ZodString;
}, z.core.$strip>;
export type MachineDeployment = z.infer<typeof MachineDeploymentSchema>;
export declare function machineDeployments(client: APIClient, machineId: string): Promise<MachineDeployment[]>;
export declare function machineAuthSetup(client: APIClient, orgId: string, publicKey: string): Promise<{
    orgId: string;
}>;
export {};
//# sourceMappingURL=machine.d.ts.map