import type { Schema, Infer } from '../base';
import { SCHEMA_KIND } from '../base';
type InferUnion<T extends Schema<any, any>[]> = Infer<T[number]>;
/**
 * Schema for union types (one of multiple possible schemas).
 * Validates against each schema until one succeeds.
 *
 * @template T - Array of schema types
 *
 * @example
 * ```typescript
 * const idSchema = s.union(s.string(), s.number());
 * idSchema.parse('abc123'); // 'abc123'
 * idSchema.parse(123); // 123
 *
 * const roleSchema = s.union(
 *   s.literal('admin'),
 *   s.literal('user'),
 *   s.literal('guest')
 * );
 * ```
 */
export declare class UnionSchema<T extends Schema<any, any>[]> implements Schema<InferUnion<T>, InferUnion<T>> {
    private schemas;
    readonly [SCHEMA_KIND] = "UnionSchema";
    description?: string;
    private parseMethods;
    constructor(schemas: T);
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => any;
        types: {
            input: InferUnion<T>;
            output: InferUnion<T>;
        };
    };
    describe(description: string): this;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    parse: (this: Schema<any, InferUnion<T>>, value: unknown) => InferUnion<T>;
    safeParse: (this: Schema<any, InferUnion<T>>, value: unknown) => import("..").SafeParseResult<InferUnion<T>>;
}
/**
 * Create a union schema (one of multiple possible types).
 *
 * @param schemas - Variable number of schemas to union
 *
 * @example
 * ```typescript
 * const idSchema = s.union(s.string(), s.number());
 *
 * const roleSchema = s.union(
 *   s.literal('admin'),
 *   s.literal('user'),
 *   s.literal('guest')
 * );
 * ```
 */
export declare function union<T extends Schema<any, any>[]>(...schemas: T): UnionSchema<T>;
export {};
//# sourceMappingURL=union.d.ts.map