import React from 'react';
import { type Context } from 'react';
export interface ContextProviderArgs {
    children?: React.ReactNode;
    baseUrl?: string;
    authHeader?: string | null;
}
export interface AgentuityContextValue {
    baseUrl: string;
    authHeader?: string | null;
    setAuthHeader?: (token: string | null) => void;
    authLoading?: boolean;
    setAuthLoading?: (loading: boolean) => void;
}
export declare const AgentuityContext: Context<AgentuityContextValue | null>;
export declare const AgentuityProvider: ({ baseUrl, authHeader: authHeaderProp, children, }: ContextProviderArgs) => React.JSX.Element;
export interface AgentuityHookValue {
    baseUrl: string;
}
/**
 * Hook to access Agentuity context (non-auth properties only).
 * For authentication state, use useAuth() instead.
 *
 * @throws Error if used outside of AgentuityProvider
 */
export declare function useAgentuity(): AgentuityHookValue;
export interface AuthContextValue {
    authHeader?: string | null;
    setAuthHeader?: (token: string | null) => void;
    authLoading?: boolean;
    setAuthLoading?: (loading: boolean) => void;
    isAuthenticated: boolean;
}
/**
 * Low-level hook for Agentuity's transport auth.
 *
 * This hook exposes the Authorization header and loading state used by
 * Agentuity's API clients (useAPI, useWebsocket, etc.).
 *
 * @example
 * ```tsx
 * import { useAuth } from '@agentuity/react';
 * const { authHeader, isAuthenticated } = useAuth();
 * ```
 *
 * @throws Error if used outside of AgentuityProvider
 */
export declare function useAuth(): AuthContextValue;
//# sourceMappingURL=context.d.ts.map