/**
 * Simple JSON-based equality check for memoization.
 * Compares stringified JSON to avoid deep equality overhead.
 */
export function jsonEqual(a, b) {
    if (a === b)
        return true;
    if (a === undefined || b === undefined)
        return false;
    if (a === null || b === null)
        return a === b;
    try {
        return JSON.stringify(a) === JSON.stringify(b);
    }
    catch {
        // Fallback for non-serializable values
        return false;
    }
}
//# sourceMappingURL=memo.js.map