/**
 * Standalone beacon script - this file is bundled and minified
 * to create the production analytics.js served at /_agentuity/webanalytics/analytics.js
 *
 * This is the single source of truth for the beacon logic.
 */
interface ScrollEvent {
    depth: number;
    timestamp: number;
}
interface AnalyticsCustomEvent {
    timestamp: number;
    name: string;
    data: string;
}
interface GeoLocation {
    country?: string;
    country_latitude?: string | number;
    country_longitude?: string | number;
    region?: string;
    region_latitude?: string | number;
    region_longitude?: string | number;
    city?: string;
    city_latitude?: string | number;
    city_longitude?: string | number;
    timezone?: string;
    latitude?: string | number;
    longitude?: string | number;
}
interface PageViewData {
    id: string;
    timestamp: number;
    timezone_offset: number;
    url: string;
    path: string;
    referrer: string;
    title: string;
    screen_width: number;
    screen_height: number;
    viewport_width: number;
    viewport_height: number;
    device_pixel_ratio: number;
    user_agent: string;
    language: string;
    scroll_depth: number;
    time_on_page: number;
    scroll_events: ScrollEvent[];
    custom_events: AnalyticsCustomEvent[];
    load_time?: number;
    dom_ready?: number;
    ttfb?: number;
    fcp?: number;
    lcp?: number;
    cls?: number;
    inp?: number;
    country?: string;
    country_latitude?: number;
    country_longitude?: number;
    region?: string;
    region_latitude?: number;
    region_longitude?: number;
    city?: string;
    city_latitude?: number;
    city_longitude?: number;
    timezone?: string;
    latitude?: number;
    longitude?: number;
    utm_source?: string;
    utm_medium?: string;
    utm_campaign?: string;
    utm_term?: string;
    utm_content?: string;
    [key: string]: unknown;
}
interface AnalyticsConfig {
    enabled: boolean;
    orgId: string;
    projectId: string;
    isDevmode: boolean;
    trackClicks?: boolean;
    trackScroll?: boolean;
    trackWebVitals?: boolean;
    trackErrors?: boolean;
    trackSPANavigation?: boolean;
    sampleRate?: number;
}
interface SessionData {
    threadId?: string;
}
interface AgentuityWindow {
    __AGENTUITY_ANALYTICS__?: AnalyticsConfig;
    __AGENTUITY_SESSION__?: SessionData;
    agentuityAnalytics?: {
        track: (name: string, properties?: Record<string, unknown>) => void;
        identify: (userId: string, traits?: Record<string, unknown>) => void;
        flush: () => void;
    };
}
declare const COLLECT_ENDPOINT = "/_agentuity/webanalytics/collect";
declare const MAX_CUSTOM_EVENTS = 1000;
/**
 * Safely stringify an object, handling circular references and other errors.
 * Returns the JSON string on success, or a fallback string on failure.
 */
declare function safeStringify(obj: unknown): string;
//# sourceMappingURL=beacon-standalone.d.ts.map