/**
 * Centralized version and package information
 * Loads package.json once and caches it
 */
import pkg from '../package.json';
export declare function getPackage(): typeof pkg;
export declare function getVersion(): string;
export declare function getPackageName(): string;
export declare function getRevision(): string;
/**
 * Normalize a version string to a Git tag format (with 'v' prefix)
 */
export declare function toTag(version: string): string;
/**
 * Get the GitHub URL for comparing two versions
 * @param fromVersion - The current/old version
 * @param toVersion - The new/target version
 * @returns GitHub compare URL
 */
export declare function getCompareUrl(fromVersion: string, toVersion: string): string;
/**
 * Get the GitHub URL for a specific release
 * @param version - The version to get the release URL for
 * @returns GitHub release URL
 */
export declare function getReleaseUrl(version: string): string;
//# sourceMappingURL=version.d.ts.map