import type { ZodType } from 'zod';
import type { CommandSchemas } from './types';
export interface ParsedArgs {
    names: string[];
    metadata: Array<{
        name: string;
        optional: boolean;
        variadic: boolean;
    }>;
}
export interface ParsedOption {
    name: string;
    description?: string;
    type: 'string' | 'number' | 'boolean' | 'array' | 'optionalString';
    hasDefault?: boolean;
    defaultValue?: unknown;
    enumValues?: string[];
}
export declare function parseArgsSchema(schema: ZodType): ParsedArgs;
export declare function parseOptionsSchema(schema: ZodType): ParsedOption[];
export declare function buildValidationInput(schemas: CommandSchemas, rawArgs: unknown[], rawOptions: Record<string, unknown>): {
    args: Record<string, unknown>;
    options: Record<string, unknown>;
};
//# sourceMappingURL=schema-parser.d.ts.map