/**
 * An implementation of the EvalRunEventProvider which wraps multiple providers
 */
export class CompositeEvalRunEventProvider {
    providers;
    constructor(...providers) {
        this.providers = providers;
    }
    /**
     * called when the eval run starts
     *
     * @param event EvalRunStartEvent
     */
    async start(event) {
        await Promise.allSettled(this.providers.map((provider) => provider.start(event)));
    }
    /**
     * called when the eval run completes
     *
     * @param event EvalRunCompleteEvent
     */
    async complete(event) {
        await Promise.allSettled(this.providers.map((provider) => provider.complete(event)));
    }
}
//# sourceMappingURL=composite.js.map