export interface DownloadOptions {
    url: string;
    headers?: Record<string, string>;
    message?: string;
    onProgress?: (percent: number, downloadedBytes: number, totalBytes: number) => void;
}
/**
 * Download a file with progress tracking
 * Returns the response body stream for further processing
 */
export declare function downloadWithProgress(options: DownloadOptions): Promise<NodeJS.ReadableStream>;
/**
 * Download a file with a TUI spinner showing progress
 */
export declare function downloadWithSpinner<T>(options: DownloadOptions, processor: (stream: NodeJS.ReadableStream) => Promise<T>): Promise<T>;
/**
 * Download a GitHub tarball with progress tracking
 */
export interface DownloadGitHubOptions {
    repo: string;
    branch?: string;
    message?: string;
}
export declare function downloadGitHubTarball(options: DownloadGitHubOptions): Promise<NodeJS.ReadableStream>;
//# sourceMappingURL=download.d.ts.map