/**
 * API Key plugin types for @agentuity/auth.
 *
 * Server-side API methods for API key management provided by BetterAuth's
 * API Key plugin. Enables programmatic access to your application.
 *
 * @see https://better-auth.com/docs/plugins/api-key
 * @module agentuity/plugins/api-key
 */
/**
 * Default API key plugin options.
 */
export const DEFAULT_API_KEY_OPTIONS = {
    enabled: true,
    apiKeyHeaders: ['x-agentuity-auth-api-key', 'X-Agentuity-Auth-Api-Key'],
    enableSessionForAPIKeys: true,
    defaultPrefix: 'ag_',
    defaultKeyLength: 64,
    enableMetadata: true,
};
//# sourceMappingURL=api-key.js.map