import { z } from 'zod';
export declare const DelegateArgsSchema: z.ZodObject<{
    agent: z.ZodEnum<{
        scout: "scout";
        builder: "builder";
        reviewer: "reviewer";
        memory: "memory";
        expert: "expert";
    }>;
    task: z.ZodString;
    context: z.ZodOptional<z.ZodString>;
    waitForResult: z.ZodDefault<z.ZodBoolean>;
}, z.core.$strip>;
export type DelegateArgs = z.infer<typeof DelegateArgsSchema>;
export declare const delegateTool: {
    name: string;
    description: string;
    args: z.ZodObject<{
        agent: z.ZodEnum<{
            scout: "scout";
            builder: "builder";
            reviewer: "reviewer";
            memory: "memory";
            expert: "expert";
        }>;
        task: z.ZodString;
        context: z.ZodOptional<z.ZodString>;
        waitForResult: z.ZodDefault<z.ZodBoolean>;
    }, z.core.$strip>;
    execute(args: DelegateArgs, _context: unknown): Promise<{
        output: string;
    }>;
};
export default delegateTool;
//# sourceMappingURL=delegate.d.ts.map