/**
 * Grouped prompts orchestration
 */
type Prettify<T> = {
    [P in keyof T]: T[P];
} & {};
export type PromptGroupAwaitedReturn<T> = {
    [P in keyof T]: Exclude<Awaited<T[P]>, symbol>;
};
export type PromptGroup<T> = {
    [P in keyof T]: (opts: {
        results: Prettify<Partial<PromptGroupAwaitedReturn<Omit<T, P>>>>;
    }) => undefined | Promise<T[P] | undefined>;
};
export interface PromptGroupOptions<T> {
    onCancel?: (opts: {
        results: Prettify<Partial<PromptGroupAwaitedReturn<T>>>;
    }) => void;
}
/**
 * Execute a group of prompts sequentially
 */
export declare function group<T>(prompts: PromptGroup<T>, opts?: PromptGroupOptions<T>): Promise<Prettify<PromptGroupAwaitedReturn<T>>>;
export {};
//# sourceMappingURL=group.d.ts.map