import { KeyValueStorageService } from '@agentuity/core';
import { createServerFetchAdapter, getServiceUrls } from '@agentuity/server';
import { getDefaultRegion } from '../../../config';
export async function createStorageAdapter(ctx) {
    const adapter = createServerFetchAdapter({
        headers: {
            Authorization: `Bearer ${ctx.auth.apiKey}`,
        },
    }, ctx.logger);
    const region = ctx.project?.region || (await getDefaultRegion(ctx.config?.name, ctx.config));
    const urls = getServiceUrls(region);
    const baseUrl = urls.catalyst;
    return new KeyValueStorageService(baseUrl, adapter);
}
//# sourceMappingURL=util.js.map