import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { decodeWorkbenchConfig } from '@agentuity/core/workbench';
import { useState } from 'react';
import { Chat } from './internal/chat';
import { Header } from './internal/header';
import { ResizableProvider, useResizable } from './internal/resizable-provider';
import { Schema } from './internal/schema';
import { WorkbenchProvider } from './internal/workbench-provider';
import { ResizableHandle, ResizablePanel, ResizablePanelGroup } from './ui/resizable';
import { ThemeProvider } from './ui/theme-provider';
import { TooltipProvider } from './ui/tooltip';
function AppContent() {
    const [schemaOpen, setSchemaOpen] = useState(false);
    const { getPanelSizes, setPanelSizes } = useResizable();
    const panelSizes = getPanelSizes('main-layout') || [70, 30];
    return (_jsxs("div", { className: "flex flex-col h-full", children: [_jsx(Header, {}), _jsxs(ResizablePanelGroup, { direction: "horizontal", className: "flex-1", onLayout: (sizes) => {
                    // Only save sizes when schema panel is open
                    if (schemaOpen && sizes.length === 2) {
                        setPanelSizes('main-layout', sizes);
                    }
                }, children: [_jsx(ResizablePanel, { defaultSize: schemaOpen ? panelSizes[0] : 100, minSize: 50, id: "chat-panel", order: 0, children: _jsx(Chat, { schemaOpen: schemaOpen, onSchemaToggle: () => setSchemaOpen(!schemaOpen) }) }), schemaOpen && (_jsxs(_Fragment, { children: [_jsx(ResizableHandle, { withHandle: true }), _jsx(ResizablePanel, { defaultSize: panelSizes[1], minSize: 25, maxSize: 50, id: "schema-panel", order: 1, children: _jsx(Schema, { onOpenChange: setSchemaOpen }) })] }))] })] }));
}
export function App({ configBase64 }) {
    const decodedConfig = decodeWorkbenchConfig(configBase64);
    const env = {
        agentuity: true,
        authenticated: import.meta.env.AGENTUITY_PUBLIC_HAS_SDK_KEY === 'true',
        cloud: false,
    };
    return (_jsx(WorkbenchProvider, { config: decodedConfig, env: env, children: _jsx(ThemeProvider, { children: _jsx(TooltipProvider, { children: _jsx(ResizableProvider, { children: _jsx(AppContent, {}) }) }) }) }));
}
export default App;
//# sourceMappingURL=App.js.map