import { type BaseEvalOptions } from './types';
export declare const concisenessPrompt = "You are evaluating whether an LLM response is unnecessarily verbose for the request type.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a reader who values efficiency and dislikes wasted words.\n2. Assess the complexity and scope of the USER REQUEST to determine appropriate response length.\n3. Identify any of the following verbosity violations in the MODEL RESPONSE:\n   - Repeating the same information in different words\n   - Excessive preamble before addressing the request\n   - Unnecessary summaries or recaps at the end\n   - Filler phrases that add no meaning (e.g., \"It's important to note that...\", \"As you may know...\")\n   - Over-explanation of simple concepts the user likely understands\n   - Including tangential context not required to answer the question\n   - Excessive hedging or qualifiers beyond what accuracy requires\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each violation:\n   - Minor filler or unnecessary phrase: \u22120.1\n   - Redundant paragraph or repeated explanation: \u22120.3\n   - Excessive preamble or postamble (multiple sentences): \u22120.3\n   - Response length grossly disproportionate to request simplicity: \u22120.5\n- Minimum score is 0.0.\n- Multiple violations compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 0.7 AND response length is reasonably proportionate to request complexity.\n\n## Constraints\n\n- Do not penalize thoroughness when the request genuinely requires detailed explanation.\n- Do not credit brevity if it sacrifices completeness.\n- Do not assume the user wants verbose responses unless explicitly requested.\n- Judge verbosity relative to what a competent, efficient response would require.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence describing verbosity issues found or confirming appropriate length>\"\n}";
type ConcisenessEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const conciseness: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: ConcisenessEvalOptions;
};
export {};
//# sourceMappingURL=conciseness.d.ts.map