import type { Logger } from '@agentuity/core';
import { APIClient, type QueueApiOptions } from '@agentuity/server';
import type { AuthData, Config, GlobalOptions } from '../../../types';
/**
 * Context required for queue API operations.
 */
export interface QueueContext {
    logger: Logger;
    auth: AuthData;
    config: Config | null;
    options: GlobalOptions;
    orgId?: string;
}
/**
 * Creates an API client for queue operations.
 *
 * Queues are global resources that don't require a project context.
 * Uses the global Catalyst API client with user authentication.
 */
export declare function createQueueAPIClient(ctx: QueueContext): Promise<APIClient>;
/**
 * Creates QueueApiOptions from the CLI context.
 * Prioritizes explicit orgId on context, then falls back to global --org-id option.
 */
export declare function getQueueApiOptions(ctx: QueueContext): QueueApiOptions | undefined;
//# sourceMappingURL=util.d.ts.map