interface WriteAgentsDocsOptions {
    /**
     * If true, only write files that don't already exist.
     * If false (default), always write files, overwriting existing ones.
     */
    onlyIfMissing?: boolean;
}
/**
 * Writes AGENTS.md documentation files to the appropriate locations in a project.
 *
 * This function generates and writes AGENTS.md files to:
 * - node_modules/@agentuity/cli/AGENTS.md (CLI documentation - full content)
 * - .agents/agentuity/sdk/[type]/AGENTS.md (Full content for agent, api, web)
 * - src/agent/AGENTS.md (Reference file pointing to .agents/)
 * - src/api/AGENTS.md (Reference file pointing to .agents/)
 * - src/web/AGENTS.md (Reference file pointing to .agents/)
 *
 * @param rootDir - The root directory of the project
 * @param options - Options for controlling write behavior
 */
export declare function writeAgentsDocs(rootDir: string, options?: WriteAgentsDocsOptions): Promise<void>;
export {};
//# sourceMappingURL=agents-docs.d.ts.map