import { z } from 'zod';
import { APIClient } from '../api';
declare const APIKeyDetailSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    orgId: z.ZodString;
    type: z.ZodString;
    expiresAt: z.ZodNullable<z.ZodString>;
    lastUsedAt: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    project: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type APIKeyDetail = z.infer<typeof APIKeyDetailSchema>;
/**
 * Get a specific API key by id
 *
 * @param client
 * @param id the API key id
 * @returns
 */
export declare function apikeyGet(client: APIClient, id: string): Promise<APIKeyDetail>;
export {};
//# sourceMappingURL=get.d.ts.map