import { createIssue, failure, success, createParseMethods, SCHEMA_KIND } from '../base';
import { optional } from '../utils/optional';
import { nullable } from '../utils/nullable';
const parseMethods = createParseMethods();
/**
 * Schema for validating null values.
 */
export class NullSchema {
    [SCHEMA_KIND] = 'NullSchema';
    description;
    '~standard' = {
        version: 1,
        vendor: 'agentuity',
        validate: (value) => {
            if (value !== null) {
                return failure([createIssue(`Expected null, got ${typeof value}`)]);
            }
            return success(value);
        },
        types: undefined,
    };
    describe(description) {
        this.description = description;
        return this;
    }
    optional() {
        return optional(this);
    }
    nullable() {
        return nullable(this);
    }
    parse = parseMethods.parse;
    safeParse = parseMethods.safeParse;
}
/**
 * Create a null schema.
 */
export function null_() {
    return new NullSchema();
}
//# sourceMappingURL=null.js.map