import { z } from 'zod';
export const AgentSchema = z.object({
    id: z.string(),
    name: z.string(),
    description: z.string().nullable(),
    identifier: z.string(),
    deploymentId: z.string().nullable(),
    devmode: z.boolean(),
    metadata: z.record(z.string(), z.unknown()).nullable(),
    createdAt: z.string(),
    updatedAt: z.string(),
    evals: z.array(z.object({
        id: z.string(),
        name: z.string(),
        description: z.string().nullable(),
        identifier: z.string().nullable(),
        devmode: z.boolean(),
        createdAt: z.string(),
        updatedAt: z.string(),
    })),
});
//# sourceMappingURL=schema.js.map