import type { GlobalOptions } from './types';
/**
 * Utilities for explain mode and dry-run mode
 */
/**
 * Check if explain mode is enabled
 */
export declare function isExplainMode(options: GlobalOptions): boolean;
/**
 * Check if dry-run mode is enabled
 */
export declare function isDryRunMode(options: GlobalOptions): boolean;
/**
 * Check if the command should execute (not explain, not dry-run unless specifically handling dry-run)
 */
export declare function shouldExecute(options: GlobalOptions): boolean;
/**
 * Explanation step for a command action
 */
export interface ExplainStep {
    action: string;
    details?: Record<string, unknown>;
}
/**
 * Explanation plan for a command
 */
export interface ExplainPlan {
    command: string;
    description: string;
    prerequisites?: string[];
    steps: ExplainStep[];
    warnings?: string[];
    estimatedDuration?: string;
}
/**
 * Output an explanation plan
 */
export declare function outputExplain(plan: ExplainPlan, options: GlobalOptions): void;
/**
 * Create a simple explain plan
 */
export declare function createExplainPlan(command: string, description: string, steps: string[]): ExplainPlan;
/**
 * Output dry-run result
 */
export declare function outputDryRun(message: string, options: GlobalOptions): void;
//# sourceMappingURL=explain.d.ts.map