import type { WebSocketConnection } from './handlers/websocket';
import type { SDPDescription, ICECandidate, SignalMessage, WebRTCSignalingCallbacks } from '@agentuity/core';
export type { SDPDescription, ICECandidate, SignalMessage, WebRTCSignalingCallbacks };
/**
 * @deprecated Use `SignalMessage` instead. Alias for backwards compatibility.
 */
export type SignalMsg = SignalMessage;
/**
 * Configuration options for WebRTC signaling.
 */
export interface WebRTCOptions {
    /** Maximum number of peers per room (default: 2) */
    maxPeers?: number;
    /** Callbacks for signaling events */
    callbacks?: WebRTCSignalingCallbacks;
}
/**
 * In-memory room manager for WebRTC signaling.
 * Tracks rooms and their connected peers.
 *
 * @example
 * ```ts
 * import { createRouter, webrtc } from '@agentuity/runtime';
 *
 * const router = createRouter();
 *
 * // Basic usage
 * router.get('/call/signal', webrtc());
 *
 * // With callbacks for monitoring
 * router.get('/call/signal', webrtc({
 *   maxPeers: 2,
 *   callbacks: {
 *     onRoomCreated: (roomId) => console.log(`Room ${roomId} created`),
 *     onPeerJoin: (peerId, roomId) => console.log(`${peerId} joined ${roomId}`),
 *     onPeerLeave: (peerId, roomId, reason) => {
 *       analytics.track('peer_left', { peerId, roomId, reason });
 *     },
 *     onMessage: (type, from, to, roomId) => {
 *       metrics.increment(`webrtc.${type}`);
 *     },
 *   },
 * }));
 * ```
 */
export declare class WebRTCRoomManager {
    private rooms;
    private wsToPeer;
    private maxPeers;
    private peerIdCounter;
    private callbacks;
    constructor(options?: WebRTCOptions);
    private generatePeerId;
    private send;
    private broadcast;
    /**
     * Handle a peer joining a room
     */
    handleJoin(ws: WebSocketConnection, roomId: string): void;
    /**
     * Handle a peer disconnecting
     */
    handleDisconnect(ws: WebSocketConnection): void;
    /**
     * Relay SDP message to target peer(s)
     */
    handleSDP(ws: WebSocketConnection, to: string | undefined, description: SDPDescription): void;
    /**
     * Relay ICE candidate to target peer(s)
     */
    handleICE(ws: WebSocketConnection, to: string | undefined, candidate: ICECandidate): void;
    /**
     * Handle incoming signaling message
     */
    handleMessage(ws: WebSocketConnection, data: string): void;
    /**
     * Get room stats for debugging
     */
    getRoomStats(): {
        roomCount: number;
        totalPeers: number;
    };
}
//# sourceMappingURL=webrtc-signaling.d.ts.map