import { type SessionEventProvider, type SessionStartEvent, type SessionCompleteEvent } from '@agentuity/core';
/**
 * An implementation of the SessionEventProvider which uses JSON logs for delivery
 */
export declare class JSONSessionEventProvider implements SessionEventProvider {
    private directory;
    constructor(directory: string);
    private makeFilename;
    /**
     * called when the session starts
     *
     * @param event SessionStartEvent
     */
    start(event: SessionStartEvent): Promise<void>;
    /**
     * called when the session completes
     *
     * @param event SessionCompleteEvent
     */
    complete(event: SessionCompleteEvent): Promise<void>;
}
//# sourceMappingURL=json.d.ts.map