import { APIClient } from '@agentuity/server';
import { type EvalRunEventProvider, type EvalRunStartEvent, type EvalRunCompleteEvent, type Logger } from '@agentuity/core';
/**
 * An implementation of the EvalRunEventProvider which uses HTTP for delivery
 */
export declare class HTTPEvalRunEventProvider implements EvalRunEventProvider {
    private apiClient;
    private logger;
    private baseUrl;
    constructor(client: APIClient, logger: Logger, baseUrl: string);
    /**
     * called when the eval run starts
     *
     * @param event EvalRunStartEvent
     */
    start(event: EvalRunStartEvent): Promise<void>;
    /**
     * called when the eval run completes
     *
     * @param event EvalRunCompleteEvent
     */
    complete(event: EvalRunCompleteEvent): Promise<void>;
}
//# sourceMappingURL=http.d.ts.map