'use client';
/**
 * Client-only exports for @agentuity/react
 *
 * This entrypoint provides React hooks and components that require a browser
 * environment. It includes the 'use client' directive for React Server Components
 * compatibility.
 *
 * @example
 * ```tsx
 * 'use client';
 *
 * import { useAPI, AgentuityProvider } from '@agentuity/react/client';
 *
 * export function MyComponent() {
 *   const { data } = useAPI({ route: 'GET /users' });
 *   return <div>{JSON.stringify(data)}</div>;
 * }
 * ```
 *
 * @remarks
 * For server-side code that needs createClient without hooks, import from
 * '@agentuity/react/server' instead.
 */
// Re-export everything from server (types, createClient, utilities)
export * from './server';
// Context and Provider
export { AgentuityContext, AgentuityProvider, useAgentuity, useAuth, } from './context';
// API hook
export { useAPI } from './api';
// WebSocket hook
export { useWebsocket } from './websocket';
// EventStream hook
export { useEventStream } from './eventstream';
// JSON memo hook
export { useJsonMemo } from './memo';
// Analytics hooks
export { useAnalytics, useTrackOnMount, withPageTracking, } from './analytics';
// Re-export additional web utilities from @agentuity/frontend
export { createReconnectManager, WebSocketManager, EventStreamManager, } from '@agentuity/frontend';
//# sourceMappingURL=client-entrypoint.js.map