import { type BaseEvalOptions } from './types';
export declare const ambiguityPrompt = "You are evaluating whether an LLM response contains language that could reasonably be interpreted in multiple conflicting ways.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a reader who takes statements at face value without charitable interpretation.\n2. Scan the MODEL RESPONSE for any of the following ambiguity types:\n   - Pronoun references with unclear antecedents\n   - Statements that could be read as affirmative or negative depending on interpretation\n   - Numeric or quantitative claims without clear units or context\n   - Conditional statements where the condition's scope is unclear\n   - Terms used without definition that have multiple common meanings\n   - Instructions with unclear ordering, grouping, or dependencies\n   - Comparisons without clear reference points (e.g., \"better\", \"faster\" without baseline)\n3. For each ambiguous element, determine if a reasonable reader could arrive at conflicting conclusions.\n\n## Score\n\n- Start from 1.0.\n- Subtract points for each ambiguity found:\n   - Minor ambiguity unlikely to cause misunderstanding: \u22120.2\n   - Moderate ambiguity that could lead to different interpretations: \u22120.4\n   - Critical ambiguity in key information that could cause wrong action: \u22120.6\n- Minimum score is 0.0.\n- Multiple ambiguities compound independently.\n\n## Pass/Fail\n\n- passed = true only if score \u2265 0.7 AND no critical ambiguities are present in key information.\n\n## Constraints\n\n- Do not assume readers will resolve ambiguity correctly through context.\n- Do not excuse ambiguity because the intended meaning seems \"obvious.\"\n- Do not credit precision in one area if other areas are ambiguous.\n- Evaluate each ambiguous element independently.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"score\": <number between 0.0 and 1.0>,\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence listing ambiguous elements found or confirming clarity>\"\n}";
type AmbiguityEvalOptions = BaseEvalOptions & {
    threshold: number;
};
export declare const ambiguity: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions & {
    threshold: number;
}> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: AmbiguityEvalOptions;
};
export {};
//# sourceMappingURL=ambiguity.d.ts.map