import { type Logger } from '@agentuity/core';
import type { Config } from '../types';
export interface InvalidPackage {
    package: string;
    error: string;
    requestedVersion?: string;
    availableVersions?: string[];
    searchUrl: string;
}
export interface AptValidationResult {
    valid: string[];
    invalid: InvalidPackage[];
}
/**
 * Validate apt dependencies against the Debian package repository.
 * Uses a local cache to avoid redundant API calls.
 * Calls the app API which checks packages against snapshot.debian.org.
 */
export declare function validateAptDependencies(packages: string[], region: string, config: Config | null, logger: Logger): Promise<AptValidationResult>;
//# sourceMappingURL=apt-validator.d.ts.map