/**
 * Vite Asset Server
 *
 * Starts a minimal Vite dev server for frontend asset transformation and HMR only.
 * Does NOT handle API routes or WebSocket - the Bun server proxies to this.
 */
import type { ViteDevServer } from 'vite';
import type { Logger } from '../../../types';
export interface ViteAssetServerResult {
    server: ViteDevServer;
    port: number;
}
export interface StartViteAssetServerOptions {
    rootDir: string;
    logger: Logger;
    workbenchPath?: string;
}
/**
 * Start Vite asset server on a dynamically-chosen port
 * Returns the server instance and the actual port number
 */
export declare function startViteAssetServer(options: StartViteAssetServerOptions): Promise<ViteAssetServerResult>;
//# sourceMappingURL=vite-asset-server.d.ts.map