import { z } from 'zod';
import { APIClient } from '../api';
declare const SnapshotFileInfoSchema: z.ZodObject<{
    path: z.ZodString;
    size: z.ZodNumber;
}, z.core.$strip>;
declare const SnapshotInfoSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    runtimeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    sizeBytes: z.ZodNumber;
    fileCount: z.ZodNumber;
    parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    createdAt: z.ZodString;
    downloadUrl: z.ZodOptional<z.ZodString>;
    files: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        size: z.ZodNumber;
    }, z.core.$strip>>>>;
    userMetadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
}, z.core.$strip>;
declare const SnapshotListDataSchema: z.ZodObject<{
    snapshots: z.ZodArray<z.ZodObject<{
        snapshotId: z.ZodString;
        runtimeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tag: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        sizeBytes: z.ZodNumber;
        fileCount: z.ZodNumber;
        parentSnapshotId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        createdAt: z.ZodString;
        downloadUrl: z.ZodOptional<z.ZodString>;
        files: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodObject<{
            path: z.ZodString;
            size: z.ZodNumber;
        }, z.core.$strip>>>>;
        userMetadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodString>>>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
export type SnapshotFileInfo = z.infer<typeof SnapshotFileInfoSchema>;
export type SnapshotInfo = z.infer<typeof SnapshotInfoSchema>;
export type SnapshotListResponse = z.infer<typeof SnapshotListDataSchema>;
declare const _SnapshotCreateParamsSchema: z.ZodObject<{
    sandboxId: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotGetParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotListParamsSchema: z.ZodObject<{
    sandboxId: z.ZodOptional<z.ZodString>;
    limit: z.ZodOptional<z.ZodNumber>;
    offset: z.ZodOptional<z.ZodNumber>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotDeleteParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotTagParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    tag: z.ZodNullable<z.ZodString>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotCreateParams = z.infer<typeof _SnapshotCreateParamsSchema>;
export type SnapshotGetParams = z.infer<typeof _SnapshotGetParamsSchema>;
export type SnapshotListParams = z.infer<typeof _SnapshotListParamsSchema>;
export type SnapshotDeleteParams = z.infer<typeof _SnapshotDeleteParamsSchema>;
export type SnapshotTagParams = z.infer<typeof _SnapshotTagParamsSchema>;
/**
 * Creates a snapshot of a sandbox's current state.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including sandbox ID and optional tag
 * @returns The created snapshot information
 * @throws {SandboxResponseError} If the snapshot creation fails
 */
export declare function snapshotCreate(client: APIClient, params: SnapshotCreateParams): Promise<SnapshotInfo>;
/**
 * Retrieves detailed information about a specific snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID
 * @returns Snapshot information including files and download URL
 * @throws {SandboxResponseError} If the snapshot is not found or request fails
 */
export declare function snapshotGet(client: APIClient, params: SnapshotGetParams): Promise<SnapshotInfo>;
/**
 * Lists snapshots with optional filtering and pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for filtering by sandbox and pagination
 * @returns Paginated list of snapshots with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function snapshotList(client: APIClient, params?: SnapshotListParams): Promise<SnapshotListResponse>;
/**
 * Deletes a snapshot and releases its storage.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including the snapshot ID to delete
 * @throws {SandboxResponseError} If the snapshot is not found or deletion fails
 */
export declare function snapshotDelete(client: APIClient, params: SnapshotDeleteParams): Promise<void>;
/**
 * Updates or removes the tag on a snapshot.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshot ID and new tag (or null to remove)
 * @returns Updated snapshot information
 * @throws {SandboxResponseError} If the snapshot is not found or update fails
 */
export declare function snapshotTag(client: APIClient, params: SnapshotTagParams): Promise<SnapshotInfo>;
declare const _SnapshotBuildInitParamsSchema: z.ZodObject<{
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    contentHash: z.ZodOptional<z.ZodString>;
    force: z.ZodOptional<z.ZodBoolean>;
    encrypt: z.ZodOptional<z.ZodBoolean>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const SnapshotBuildInitResponseSchema: z.ZodObject<{
    snapshotId: z.ZodOptional<z.ZodString>;
    uploadUrl: z.ZodOptional<z.ZodString>;
    s3Key: z.ZodOptional<z.ZodString>;
    publicKey: z.ZodOptional<z.ZodString>;
    unchanged: z.ZodOptional<z.ZodBoolean>;
    existingId: z.ZodOptional<z.ZodString>;
    existingName: z.ZodOptional<z.ZodString>;
    existingTag: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
declare const _SnapshotBuildFinalizeParamsSchema: z.ZodObject<{
    snapshotId: z.ZodString;
    sizeBytes: z.ZodNumber;
    fileCount: z.ZodNumber;
    files: z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        size: z.ZodNumber;
    }, z.core.$strip>>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    orgId: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type SnapshotBuildInitParams = z.infer<typeof _SnapshotBuildInitParamsSchema>;
export type SnapshotBuildInitResponse = z.infer<typeof SnapshotBuildInitResponseSchema>;
export type SnapshotBuildFinalizeParams = z.infer<typeof _SnapshotBuildFinalizeParamsSchema>;
/**
 * Initialize a snapshot build by getting a presigned upload URL.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including runtime and optional name/tag/description
 * @returns Snapshot ID and presigned upload URL
 * @throws {SandboxResponseError} If the initialization fails
 */
export declare function snapshotBuildInit(client: APIClient, params: SnapshotBuildInitParams): Promise<SnapshotBuildInitResponse>;
/**
 * Finalize a snapshot build after uploading the archive.
 *
 * @param client - The API client to use for the request
 * @param params - Parameters including snapshot details and file metadata
 * @returns The created snapshot information
 * @throws {SandboxResponseError} If the finalization fails
 */
export declare function snapshotBuildFinalize(client: APIClient, params: SnapshotBuildFinalizeParams): Promise<SnapshotInfo>;
export {};
//# sourceMappingURL=snapshot.d.ts.map