import { z } from 'zod';
import { APIClient } from '../api';
declare const _ProjectExistsRequestSchema: z.ZodObject<{
    name: z.ZodString;
    organization_id: z.ZodString;
}, z.core.$strip>;
declare const ProjectExistsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodBoolean;
}, z.core.$strip>], "success">;
export type ProjectExistsRequest = z.infer<typeof _ProjectExistsRequestSchema>;
export type ProjectExistsResponse = z.infer<typeof ProjectExistsResponseSchema>;
/**
 * Check if a project exists by name within an organization
 *
 * @param client
 * @param body
 * @returns
 */
export declare function projectExists(client: APIClient, body: ProjectExistsRequest): Promise<boolean>;
export {};
//# sourceMappingURL=exists.d.ts.map