/**
 * API Client for Agentuity Platform
 *
 * Handles HTTP requests to the API with automatic error parsing and User-Agent headers.
 */
import { z } from 'zod';
import type { Logger } from '@agentuity/core';
export interface APIClientConfig {
    skipVersionCheck?: boolean;
    userAgent?: string;
    maxRetries?: number;
    retryDelayMs?: number;
    headers?: Record<string, string>;
}
declare const ZodIssuesSchema: z.ZodArray<z.ZodObject<{
    code: z.ZodString;
    input: z.ZodOptional<z.ZodUnknown>;
    path: z.ZodArray<z.ZodUnion<readonly [z.ZodString, z.ZodNumber]>>;
    message: z.ZodString;
}, z.core.$strip>>;
export type IssuesType = z.infer<typeof ZodIssuesSchema>;
export declare const APIError: {
    new (args?: ({
        url: string;
        status: number;
        sessionId?: string | null;
    } & {
        message?: string;
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "APIErrorResponse";
    } & Readonly<{
        url: string;
        status: number;
        sessionId?: string | null;
    }>;
    readonly defaultMessage?: string;
};
export declare const ValidationInputError: {
    new (args?: ({
        url: string;
        issues: IssuesType;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ValidationInputError";
    } & Readonly<{
        url: string;
        issues: IssuesType;
    }>;
    readonly defaultMessage?: string;
};
export declare const ValidationOutputError: {
    new (args?: ({
        url: string;
        issues: IssuesType;
        sessionId?: string | null;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ValidationOutputError";
    } & Readonly<{
        url: string;
        issues: IssuesType;
        sessionId?: string | null;
    }>;
    readonly defaultMessage?: string;
};
export declare const UpgradeRequiredError: {
    new (args?: ({
        sessionId?: string | null;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "UpgradeRequiredError";
    } & Readonly<{
        sessionId?: string | null;
    }>;
    readonly defaultMessage?: string;
};
export declare const MaxRetriesError: {
    new (args?: {
        cause?: unknown;
    } | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "MaxRetriesError";
    } & Readonly<Record<string, never>>;
    readonly defaultMessage?: string;
} & (<Shape extends {
    [x: string]: any;
} = Record<string, never>>() => {
    new (args?: (Shape extends Record<string, never> ? {
        cause?: unknown;
    } : Shape & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "MaxRetriesError";
    } & Readonly<Shape>;
    readonly defaultMessage?: string;
});
export declare class APIClient {
    #private;
    constructor(baseUrl: string, logger: Logger, config?: APIClientConfig);
    constructor(baseUrl: string, logger: Logger, apiKey: string, config?: APIClientConfig);
    /**
     * GET request
     */
    get<TResponse = void>(endpoint: string, responseSchema?: z.ZodType<TResponse>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
    /**
     * POST request with optional body
     */
    post<TResponse = void, TBody = unknown>(endpoint: string, body?: TBody, responseSchema?: z.ZodType<TResponse>, bodySchema?: z.ZodType<TBody>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
    /**
     * PUT request with optional body
     */
    put<TResponse = void, TBody = unknown>(endpoint: string, body?: TBody, responseSchema?: z.ZodType<TResponse>, bodySchema?: z.ZodType<TBody>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
    /**
     * DELETE request
     */
    delete<TResponse = void>(endpoint: string, responseSchema?: z.ZodType<TResponse>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
    /**
     * PATCH request with optional body
     */
    patch<TResponse = void, TBody = unknown>(endpoint: string, body?: TBody, responseSchema?: z.ZodType<TResponse>, bodySchema?: z.ZodType<TBody>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
    /**
     * Raw GET request that returns the Response object directly.
     * Useful for streaming responses where you need access to the body stream.
     */
    rawGet(endpoint: string, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<Response>;
    /**
     * Raw POST request that returns the Response object directly.
     * Useful for binary uploads where you need to pass raw body data.
     */
    rawPost(endpoint: string, body: Uint8Array | ArrayBuffer | ReadableStream<Uint8Array> | string, contentType: string, signal?: AbortSignal): Promise<Response>;
    /**
     * Generic request method (prefer HTTP verb methods: get, post, put, delete, patch)
     */
    request<TResponse = void, TBody = unknown>(method: string, endpoint: string, responseSchema?: z.ZodType<TResponse>, body?: TBody, bodySchema?: z.ZodType<TBody>, signal?: AbortSignal, extraHeaders?: Record<string, string>): Promise<TResponse>;
}
export declare function getAPIBaseURL(region?: string, overrides?: {
    api_url?: string;
}): string;
export declare function getAppBaseURL(region?: string, overrides?: {
    app_url?: string;
} | null): string;
export declare const APIResponseSchema: <T extends z.ZodType>(dataSchema: T) => z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: T;
}, z.core.$strip>], "success">;
export declare const APIResponseSchemaOptionalData: <T extends z.ZodType>(dataSchema: T) => z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodOptional<T>;
}, z.core.$strip>], "success">;
export declare const APIResponseSchemaNoData: () => z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export {};
//# sourceMappingURL=api.d.ts.map