import type { Schema } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema that coerces values to numbers using Number(value).
 * Fails if the result is NaN.
 *
 * @example
 * ```typescript
 * const schema = s.coerce.number();
 * schema.parse('123'); // 123
 * schema.parse(true); // 1
 * schema.parse('abc'); // throws ValidationError
 * ```
 */
export declare class CoerceNumberSchema implements Schema<unknown, number> {
    readonly [SCHEMA_KIND] = "CoerceNumberSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<number>;
        types: {
            input: unknown;
            output: number;
        };
    };
    describe(description: string): this;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    parse: (this: Schema<any, number>, value: unknown) => number;
    safeParse: (this: Schema<any, number>, value: unknown) => import("..").SafeParseResult<number>;
}
/**
 * Create a schema that coerces values to numbers.
 * Useful for parsing form data or query parameters where numbers come as strings.
 */
export declare function coerceNumber(): CoerceNumberSchema;
//# sourceMappingURL=number.d.ts.map