import type { SpanProcessor } from '@opentelemetry/sdk-trace-base';
import { type Meter, type Tracer } from '@opentelemetry/api';
import { OTLPLogExporter } from '@opentelemetry/exporter-logs-otlp-http';
import type { Resource } from '@opentelemetry/resources';
import { BatchLogRecordProcessor, LoggerProvider, type LogRecordProcessor } from '@opentelemetry/sdk-logs';
import type { Logger } from '../logger';
import type { LogLevel } from '@agentuity/core';
import { JSONLLogExporter } from './exporters';
/**
 * Configuration for OpenTelemetry initialization
 */
export interface OtelConfig {
    url?: string;
    name: string;
    version: string;
    bearerToken?: string;
    orgId?: string;
    projectId?: string;
    deploymentId?: string;
    environment?: string;
    cliVersion?: string;
    devmode?: boolean;
    spanProcessors?: Array<SpanProcessor>;
    logLevel?: LogLevel;
    jsonlBasePath?: string;
}
/**
 * Response from OpenTelemetry initialization
 */
export interface OtelResponse {
    tracer: Tracer;
    meter: Meter;
    logger: Logger;
    shutdown: () => Promise<void>;
}
export declare const createResource: (config: OtelConfig) => Resource;
export declare const createAgentuityLoggerProvider: ({ url, headers, resource, jsonlBasePath, useConsoleExporters, }: {
    url?: string;
    headers?: Record<string, string>;
    resource: Resource;
    logLevel: LogLevel;
    jsonlBasePath?: string;
    useConsoleExporters: boolean;
}) => {
    processor: LogRecordProcessor;
    provider: LoggerProvider;
    exporter: JSONLLogExporter | OTLPLogExporter | undefined;
};
export declare const createUserLoggerProvider: ({ url, headers, resource, }: {
    url: string;
    headers?: Record<string, string>;
    resource: Resource;
}) => {
    provider: LoggerProvider;
    exporter: OTLPLogExporter;
    processor: BatchLogRecordProcessor;
};
/**
 * Registers and initializes OpenTelemetry with the specified configuration
 *
 * @param config - The configuration for OpenTelemetry
 * @returns An object containing the tracer, logger, and shutdown function
 */
export declare function registerOtel(config: OtelConfig): OtelResponse;
//# sourceMappingURL=otel.d.ts.map