import { propagation } from '@opentelemetry/api';
/**
 * Injects trace context into response headers using the OpenTelemetry propagation API
 *
 * @param headers - Optional existing headers to include
 * @returns A record of headers with trace context injected
 */
export declare function injectTraceContextToHeaders(headers?: Record<string, string> | Headers): Record<string, string>;
/**
 * Extracts trace context from Bun Request headers
 *
 * @param req - The Bun Request object
 * @returns The context with trace information
 */
export declare function extractTraceContextFromRequest(req: Request): ReturnType<typeof propagation.extract>;
//# sourceMappingURL=http.d.ts.map