/**
 * Create an EventSource (SSE) client wrapper with event-based API.
 *
 * Note: Native EventSource has limited authentication support.
 * - withCredentials: true will send cookies and HTTP auth headers
 * - For custom Authorization headers, consider using @microsoft/fetch-event-source
 */
export function createEventStreamClient(url, options) {
    const eventSource = new EventSource(url, {
        withCredentials: options?.withCredentials ?? false,
    });
    const handlers = {
        message: new Set(),
        open: new Set(),
        error: new Set(),
    };
    // Set up native EventSource event listeners
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    eventSource.onmessage = (event) => {
        handlers.message.forEach((handler) => handler(event));
    };
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    eventSource.onopen = (event) => {
        handlers.open.forEach((handler) => handler(event));
    };
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    eventSource.onerror = (event) => {
        handlers.error.forEach((handler) => handler(event));
    };
    return {
        on: ((event, handler) => {
            handlers[event].add(handler);
        }),
        close() {
            eventSource.close();
        },
    };
}
//# sourceMappingURL=eventstream.js.map