import { type BaseEvalOptions } from './types';
export declare const selfReferencePrompt = "You are evaluating whether an LLM response inappropriately references the model itself.\n\n## Inputs\n\n- USER REQUEST: {{USER_REQUEST}}\n- MODEL RESPONSE: {{MODEL_RESPONSE}}\n\n## Your task\n\n1. Assume a product manager who wants responses to feel like expert answers, not AI disclaimers.\n2. Scan the MODEL RESPONSE for any self-referential language, including:\n   - Direct AI identification: \"As an AI...\", \"As a language model...\", \"As an assistant...\"\n   - Capability disclaimers: \"I don't have access to...\", \"I cannot browse the internet...\", \"My training data...\"\n   - Knowledge cutoff references: \"As of my knowledge cutoff...\", \"I don't have information after...\"\n   - Anthropomorphization disclaimers: \"I don't have feelings...\", \"I don't have opinions...\"\n   - Meta-statements about generation: \"I'm generating this response...\", \"Based on my training...\"\n3. Determine whether the USER REQUEST explicitly asked about the model's nature, capabilities, or limitations.\n\n## Pass/Fail\n\n- passed = true only if no self-referential language is present OR the user explicitly asked about the model itself.\n- passed = false if any self-referential language appears without explicit user prompting.\n\n## Constraints\n\n- Do not excuse self-reference as \"transparency\" unless the user asked for it.\n- Do not excuse self-reference because it provides useful context.\n- First-person pronouns (\"I think...\", \"I would suggest...\") are acceptable; AI-specific identification is not.\n- References to limitations are only acceptable if directly relevant to why a request cannot be fulfilled.\n- \"I don't know\" is acceptable; \"As an AI, I don't know\" is not.\n\n## Output format (STRICT JSON, one line reason):\n\n{\n  \"passed\": <true|false>,\n  \"reason\": \"<single concise sentence quoting self-referential language found or confirming none detected>\"\n}";
export declare const selfReference: <TAgentInput extends import("@agentuity/core").StandardSchemaV1 | undefined = any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1 | undefined = any>(overrides?: (Partial<{
    name?: string;
    description?: string;
} & BaseEvalOptions> & {
    middleware?: import("./types").EvalMiddleware<TAgentInput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentInput> : any, TAgentOutput extends import("@agentuity/core").StandardSchemaV1<unknown, unknown> ? import("@agentuity/core").InferOutput<TAgentOutput> : any, {
        request: string;
    } & {
        context?: string | undefined;
    }, {
        response: string;
    } & {}> | undefined;
}) | undefined) => import("@agentuity/runtime").CreateEvalConfig<any, any> & {
    name: string;
    options: BaseEvalOptions;
};
//# sourceMappingURL=self-reference.d.ts.map