/**
 * Detects if a file path represents a subagent based on path structure.
 *
 * Subagents follow the pattern: agent/parent/child/agent.ts or agent/parent/child/route.ts
 * The path structure is currently hardcoded to 4 segments but could be made configurable later.
 *
 * @param filePath - The file path to analyze (can include leading './')
 * @param srcDir - Optional source directory to strip from the path
 * @returns Object with isSubagent flag and parentName if detected
 */
export declare function detectSubagent(filePath: string, srcDir?: string): {
    isSubagent: boolean;
    parentName: string | null;
};
//# sourceMappingURL=detectSubagent.d.ts.map