import { DeploymentConfig, BuildMetadataSchema as ServerBuildMetadataSchema, } from '@agentuity/server';
import { z as zod } from 'zod';
export { DeploymentConfig };
export const ConfigSchema = zod.object({
    name: zod.string().describe('Profile name'),
    auth: zod
        .object({
        api_key: zod.string().optional().describe('API authentication key'),
        user_id: zod.string().optional().describe('User ID'),
        expires: zod.number().optional().describe('Authentication expiration timestamp'),
    })
        .optional()
        .describe('Authentication credentials (managed by login/logout commands)'),
    devmode: zod
        .object({
        hostname: zod.string().optional().describe('Development mode hostname'),
    })
        .optional()
        .describe('Development mode configuration'),
    overrides: zod
        .object({
        api_url: zod.url().optional().describe('Override API base URL'),
        app_url: zod.url().optional().describe('Override app base URL'),
        transport_url: zod.url().optional().describe('Override transport URL'),
        stream_url: zod.url().optional().describe('Override stream URL'),
        kv_url: zod.url().optional().describe('Override keyvalue URL'),
        sandbox_url: zod.url().optional().describe('Override sandbox URL'),
        vector_url: zod.url().optional().describe('Override vector store URL'),
        catalyst_url: zod.url().optional().describe('Override catalyst URL'),
        ion_url: zod.url().optional().describe('Override ion URL'),
        gravity_url: zod.url().optional().describe('Override gravity URL'),
        skip_version_check: zod.boolean().optional().describe('Skip CLI version check on startup'),
    })
        .optional()
        .nullable()
        .describe('URL and behavior overrides'),
    preferences: zod
        .object({
        last_update_check: zod.number().optional().describe('Last update check timestamp'),
        last_legacy_warning: zod.number().optional().describe('Last legacy CLI warning timestamp'),
        signup_banner_shown: zod.boolean().optional().describe('If the signup banner was shown'),
        orgId: zod.string().optional().describe('Default organization ID'),
        region: zod.string().optional().describe('Default cloud region'),
        project_dir: zod.string().optional().describe('Last used project directory'),
    })
        .optional()
        .describe('User preferences'),
    gravity: zod
        .object({
        version: zod.string().optional().describe('The current gravity version'),
        checked: zod.number().optional().describe('Last gravity check timestamp'),
    })
        .optional()
        .describe('the gravity client information'),
});
export function createSubcommand(definition) {
    return definition;
}
export function createCommand(definition) {
    return definition;
}
export const ProjectSchema = zod.object({
    projectId: zod.string().describe('the project id'),
    orgId: zod.string().describe('the organization id'),
    region: zod.string().describe('the region identifier that the project is deployed into'),
    deployment: DeploymentConfig.optional().describe('the deployment configuration'),
    skipGitSetup: zod
        .boolean()
        .optional()
        .describe('whether to skip the git integration setup prompt during deploy'),
});
export const BuildMetadataSchema = ServerBuildMetadataSchema;
export const DeployOptionsSchema = zod.object({
    logsUrl: zod.url().optional().describe('The url to the CI build logs'),
    trigger: zod
        .enum(['cli', 'workflow', 'webhook'])
        .default('cli')
        .optional()
        .describe('The trigger that caused the build'),
    commitUrl: zod.url().optional().describe('The url to the CI commit'),
    message: zod.string().optional().describe('The message to associate with this deployment'),
    commit: zod.string().optional().describe('The commit SHA for this deployment'),
    branch: zod.string().optional().describe('The git branch for this deployment'),
    provider: zod.string().optional().describe('The CI provider name (attempts to autodetect)'),
    repo: zod.string().optional().describe('The repo url'),
    event: zod
        .enum(['pull_request', 'push', 'manual', 'workflow'])
        .default('manual')
        .optional()
        .describe('The event that triggered the deployment'),
    pullRequestNumber: zod.number().optional().describe('the pull request number'),
    pullRequestUrl: zod.url().optional().describe('the pull request url'),
});
//# sourceMappingURL=types.js.map