import type { APIClient } from '../../api';
export interface GithubIntegration {
    id: string;
    githubAccountName: string;
    githubAccountType: 'user' | 'org';
    connectedBy: string;
    connectedAt: string;
}
export interface GithubIntegrationStartResult {
    shortId: string;
}
export interface GithubIntegrationStatusResult {
    connected: boolean;
    integrations: GithubIntegration[];
}
export declare function startGithubIntegration(apiClient: APIClient, orgId: string): Promise<GithubIntegrationStartResult>;
export declare function getGithubIntegrationStatus(apiClient: APIClient, orgId: string): Promise<GithubIntegrationStatusResult>;
export interface GithubDisconnectResult {
    disconnected: boolean;
}
export declare function disconnectGithubIntegration(apiClient: APIClient, orgId: string, integrationId: string): Promise<GithubDisconnectResult>;
export interface ExistingGithubIntegration {
    id: string;
    integrationId: string | null;
    orgId: string;
    orgName: string;
    githubAccountName: string;
}
export declare function getExistingGithubIntegrations(apiClient: APIClient, excludeOrgId?: string): Promise<ExistingGithubIntegration[]>;
export declare function copyGithubIntegration(apiClient: APIClient, fromOrgId: string, toOrgId: string): Promise<boolean>;
export declare function pollForGithubIntegration(apiClient: APIClient, orgId: string, initialCount: number, timeoutMs?: number): Promise<GithubIntegrationStatusResult>;
export interface GithubRepo {
    id: number;
    name: string;
    fullName: string;
    private: boolean;
    defaultBranch: string;
    integrationId: string;
}
export declare function listGithubRepos(apiClient: APIClient, orgId: string, integrationId?: string): Promise<GithubRepo[]>;
export interface LinkProjectOptions {
    projectId: string;
    repoFullName: string;
    branch: string;
    autoDeploy: boolean;
    previewDeploy: boolean;
    directory?: string;
    integrationId?: string;
}
export declare function linkProjectToRepo(apiClient: APIClient, options: LinkProjectOptions): Promise<boolean>;
export declare function unlinkProjectFromRepo(apiClient: APIClient, projectId: string): Promise<boolean>;
export interface ProjectGithubStatus {
    linked: boolean;
    repoFullName?: string;
    branch?: string;
    autoDeploy?: boolean;
    previewDeploy?: boolean;
    directory?: string;
}
export declare function getProjectGithubStatus(apiClient: APIClient, projectId: string): Promise<ProjectGithubStatus>;
//# sourceMappingURL=api.d.ts.map